/**************************************************************************************************
 * Public header file for Radio Register extension to support extended PHY.
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef PHYPIBEXTENDED_H_
#define PHYPIBEXTENDED_H_

#define mMaxCarrierFreqNum_c ( 0x00FFFFFF )

/************************************************************************************
*************************************************************************************
* Public prototypes for extended PHY
*************************************************************************************
************************************************************************************/

uint8_t PhyPib_SetOperationMode(uint8_t opMode);
void PhyPib_SetPowerStep(uint8_t outputPower);
uint8_t PhyPib_SetCarrierFreq(uint32_t carrierFrequency);
void PhyPib_SetBitrate(uint16_t bitrate);
void PhyPib_SetFreqDeviation(uint16_t freqDev);
uint8_t PhyPib_EnableSequencer(uint8_t enableSequencer);
uint8_t PhyPib_SetDataMode(uint8_t dataMode);
uint8_t PhyPib_SetModulationType(uint8_t modulationType);
uint8_t PhyPib_SetModulationShaping(uint8_t modulationShaping);
uint8_t PhyPib_SetPowerAmpMode(uint8_t paMode);
uint8_t PhyPib_SetPaRamp(uint8_t paRampValueUs);
uint8_t PhyPib_SetDccFreq(uint8_t dccFreq);
uint8_t PhyPib_SetRxFilterBw(uint8_t rxFilterBw);
uint8_t PhyPib_SetDccFreqAfc(uint8_t dccFreqAfc);
uint8_t PhyPib_SetRxFilterBwAfc(uint8_t rxFilterBwAfc);
uint8_t PhyPib_SetOokThresholdType(uint8_t thresholdType);
void PhyPib_SetOokFixedThreshold (uint8_t fixedThresholdDb);
uint8_t PhyPib_SetOokPeakThreshStep (uint8_t peakThreshStep);
uint8_t PhyPib_SetOokPeakThreshDec (uint8_t peakThreshDec);
uint8_t PhyPib_SetOokAvgThreshFilt (uint8_t avgThresh);
void PhyPib_EnableAfcLowBeta (bool_t afcLowBetaOn);
void PhyPib_SetLowBetaAfcOffset (uint8_t lowBetaAfcOffset);
void PhyPib_EnableAfcAutoclear (bool_t afcAutoClearOn);
void PhyPib_EnableAfcAuto (bool_t afcAutoOn);
void PhyPib_ClearAfc (void);
void PhyPib_SetRxTimeout (uint8_t timeout);
void PhyPib_SetRxTimeoutThreshold (uint8_t timeoutTresh);
void PhyPib_SetRssiThreshold (uint8_t rssiTresh);
void PhyPib_SetFifoThreshold (uint8_t fifoThresh);
void PhyPib_RestartRx (void);
uint8_t PhyPib_SetLnaInputImpedance (uint8_t lnaZin);
uint8_t PhyPib_EnableSensitivityBoost(uint8_t sensitivityBoostOn);
uint16_t PhyPib_GetAfc(void);
uint16_t PhyPib_GetFei(void);
uint8_t PhyPib_GetRssi(void);
void PhyPib_SetConfig(uint8_t freqBand, uint8_t operatingMode, uint8_t outputPower, uint8_t rfChannel);
uint8_t PhyPib_SetSyncWordSize(uint8_t syncWordSize);
uint8_t PhyPib_SetSyncWordValue(uint8_t syncWordValueReg, uint8_t syncValue);
uint8_t PhyPib_SetInterPacketRxDelay(uint8_t interPacketRxDelay);
void PhyPib_PABoostCfg(uint8_t u8PAConfig);
void PhyPib_SetLnaGain(uint8_t gainValue); 
uint8_t PhyPib_SetListenResRx (uint8_t listenResolution);
uint8_t PhyPib_SetListenCoefRx (uint8_t listenCoef);

#endif /* PHYPIBEXTENDED_H_ */
